unit fMain;

interface

uses
  SysUtils, Variants, Classes, QControls, QForms,
  QDialogs, DBXpress, FMTBcd, QGrids, QDBGrids, DB, SqlExpr, Provider,
  DBClient, QExtCtrls, QStdCtrls;

type
  TfrmMain = class(TForm)
    SQLConnection1: TSQLConnection;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    SQLDataSet1: TSQLDataSet;
    ClientDataSet1: TClientDataSet;
    DataSetProvider1: TDataSetProvider;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    SQLQuery1: TSQLQuery;
    Button4: TButton;
    Button5: TButton;
    Bevel1: TBevel;
    eFirstName: TEdit;
    Label1: TLabel;
    eLastName: TEdit;
    Label2: TLabel;
    eEmail: TEdit;
    Label3: TLabel;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    SQLStoredProc2: TSQLStoredProc;
    SQLStoredProc1: TSQLStoredProc;
    SQLStoredProc3: TSQLStoredProc;
    Button11: TButton;
    SQLConnection2: TSQLConnection;
    SQLConnection3: TSQLConnection;
    SQLQuery2: TSQLQuery;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure ClientDataSet1AfterScroll(DataSet: TDataSet);
    procedure Button8Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.Button1Click(Sender: TObject);
begin
  try
    SQLQuery2.SQL.Clear;
    SQLQuery2.SQL.Add('create database test_sp');
    SQLQuery2.ExecSQL();
    ShowMessage('DataBase created successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.Button2Click(Sender: TObject);
begin
  try
    ClientDataSet1.Close;

    SQLConnection1.Close;
    SQLConnection2.Close;
    SQLConnection3.Close;

    SQLQuery2.SQL.Clear;
    SQLQuery2.SQL.Add('use master');
    SQLQuery2.SQL.Add('drop database test_sp');
    SQLQuery2.ExecSQL();
    ShowMessage('DataBase deleted successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.Button3Click(Sender: TObject);
begin
  try
    SQLQuery2.SQL.Clear;
    SQLQuery2.SQL.Add('use test_sp');
    SQLQuery2.SQL.Add('create table customer (	id numeric identity,');
    SQLQuery2.SQL.Add('firstname varchar(55),');
    SQLQuery2.SQL.Add('lastname varchar(55),');
    SQLQuery2.SQL.Add('e_mail       varchar(20))');
    SQLQuery2.ExecSQL();
    ShowMessage('Table created successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.Button5Click(Sender: TObject);
begin
 try
    // SQL command drop table
    SQLQuery2.SQL.Clear;
    SQLQuery2.SQL.Add('use test_sp');
    SQLQuery2.SQL.Add('drop table customer');
    SQLQuery2.ExecSQL();

    SQLDataSet1.Close;
    ClientDataSet1.Close;

    ShowMessage('Table dropped successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.Button9Click(Sender: TObject);
begin
  try
    SQLQuery2.SQL.Clear;
    SQLQuery2.SQL.Add('create procedure sp_insertCustomer');
    SQLQuery2.SQL.Add('@a_firstname varchar(55),');
    SQLQuery2.SQL.Add('@a_lastname varchar(55),');
    SQLQuery2.SQL.Add('@a_email varchar(20)');
    SQLQuery2.SQL.Add('as');
    SQLQuery2.SQL.Add('insert into customer values(@a_firstname, @a_lastname, @a_email)');
    SQLQuery2.SQL.Add('return @@identity');
    SQLQuery2.ExecSQL();

    SQLQuery2.SQL.Clear;
    SQLQuery2.SQL.Add('create procedure sp_modifyCustomer');
    SQLQuery2.SQL.Add('@a_id numeric,');
    SQLQuery2.SQL.Add('@a_firstname varchar(55),');
    SQLQuery2.SQL.Add('@a_lastname varchar(55),');
    SQLQuery2.SQL.Add('@a_email varchar(20)');
    SQLQuery2.SQL.Add('as');
    SQLQuery2.SQL.Add('update customer set firstname = @a_firstname, lastname = @a_lastname, e_mail = @a_email where id  = @a_id');
    SQLQuery2.ExecSQL();

    SQLQuery2.SQL.Clear;
    SQLQuery2.SQL.Add('create procedure sp_deleteCustomer');
    SQLQuery2.SQL.Add('@a_id numeric');
    SQLQuery2.SQL.Add('as');
    SQLQuery2.SQL.Add('delete from customer where id  = @a_id');
    SQLQuery2.ExecSQL();

    ShowMessage('Procedures created successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;

end;

procedure TfrmMain.Button6Click(Sender: TObject);
begin
  try
    SQLStoredProc2.StoredProcName := 'sp_insertCustomer';
    SQLStoredProc2.ParamByName('@a_firstname').AsString := eFirstName.Text ;
    SQLStoredProc2.ParamByName('@a_lastname').AsString := eLastName.Text ;
    SQLStoredProc2.ParamByName('@a_email').AsString := eEmail.Text ;

    SQLStoredProc2.ExecProc;

    if SQLDataSet1.Active then
      SQLDataSet1.Refresh
    else
      SQLDataSet1.Open;
    if ClientDataSet1.Active then
      ClientDataSet1.Refresh
    else
      ClientDataSet1.Open;

    ClientDataSet1.Locate('id',SQLStoredProc2.ParamByName('Result').AsInteger,[loCaseInsensitive]) ;

    eEmail.Text := '';
    eLastName.Text := '';
    eFirstName.Text := '';
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.Button10Click(Sender: TObject);
begin
  try
  SQLQuery2.SQL.Clear;
  SQLQuery2.SQL.Add('drop procedure sp_insertCustomer');
  SQLQuery2.SQL.Add('drop procedure sp_modifyCustomer');
  SQLQuery2.SQL.Add('drop procedure sp_deleteCustomer');
  SQLQuery2.ExecSQL();
  ShowMessage('Procedures dropped successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;

end;

procedure TfrmMain.Button7Click(Sender: TObject);
begin
  try
SQLConnection2.Connected := true;

SQLStoredProc1.StoredProcName := 'sp_modifyCustomer';

SQLStoredProc1.ParamByName('@a_id').AsBCD := ClientDataSet1.FieldByName('id').AsInteger;
SQLStoredProc1.ParamByName('@a_firstname').AsString := eFirstName.Text ;
SQLStoredProc1.ParamByName('@a_lastname').AsString := eLastName.Text ;
SQLStoredProc1.ParamByName('@a_email').AsString := eEmail.Text ;

SQLStoredProc1.ExecProc;

    if SQLDataSet1.Active then
      SQLDataSet1.Refresh
    else
      SQLDataSet1.Open;
    if ClientDataSet1.Active then
      ClientDataSet1.Refresh
    else
      ClientDataSet1.Open;

  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.ClientDataSet1AfterScroll(DataSet: TDataSet);
begin
  try
  eFirstName.Text := ClientDataSet1.FieldByName('firstname').AsString;
  eLastName.Text := ClientDataSet1.FieldByName('lastname').AsString;
  eEmail.Text := ClientDataSet1.FieldByName('e_mail').AsString;
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.Button8Click(Sender: TObject);
begin
try
    SQLConnection2.Connected := true;

    SQLStoredProc1.StoredProcName := 'sp_deleteCustomer';

    SQLStoredProc1.ParamByName('@a_id').AsBCD := ClientDataSet1.FieldByName('id').AsInteger;

    SQLStoredProc1.ExecProc;

    SQLDataSet1.Refresh;
    ClientDataSet1.Refresh;
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfrmMain.Button11Click(Sender: TObject);
begin
  try
    SQLDataSet1.Open;
    ClientDataSet1.Open;
  except
    on E: Exception do begin
      ShowMessage(E.Message);
        SQLDataSet1.Close;
        ClientDataSet1.Close;
      end;
  end;
end;

end.
